#!/usr/bin/env python3
import numpy as np

#I wrote the script to take into account a comment after the atom indexes in the CVs file,
#you will need either to modify this script or to add a ! after the last index in the line,
#check the CVs file in this folder to understand better what I mean.
def index_CVs(file='CVs'):
    indexes=[]
    with open(file) as f:
        for raw_line in f:
            line = raw_line.strip(' ')
            if line.startswith('atoms'):
                indexes.append
                indexes.append(line.split()[2:-1])
    return indexes


string = np.genfromtxt('guess') #this is either the converged string file or your initial guess

for node_idx, node in enumerate(string):
    with open(f"restr{node_idx + 1}", "w") as restr_file:
        atoms = index_CVs()
        for cv_atoms, cv_value in zip(atoms, node):
            r1, r4, rk2, rk3 = (cv_value - 1, cv_value + 1, 500, 500) if len(cv_atoms) == 2 else (cv_value - 10, cv_value + 10, 100, 100)
            restr_file.write(f"&rst\niat={' '.join(map(str, cv_atoms))}\n"
                              f"r1={r1:.2f}, r2={cv_value}, r3={cv_value}, r4={r4:.2f}\n"
                              f"rk2={rk2}, rk3={rk3}\n"
                              "/\n")
