#!/bin/bash
#SBATCH --time=3-00:00:00
#SBATCH --job-name=scanMC
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=1

#one step for each line in the guess file
POINTS=96
module load apps/amber/24.tools.24


cd $SLURM_SUBMIT_DIR 

#change it for the path of your reactant's structure
#cp 1_react_QM_equilibration/0.rst7 .

#in this example I was running minimizations, but in your case you can use MD, this you will obtain an alreade relaxed product structure,
#the simulation steps deppend on the amount of computational resources you have.
for i in $(seq 1 $POINTS);do
    sed -e "s/__NODE__/$i/g" in_template > in
    sander.MPI -O  -i in -o $i.out -c $((i-1)).rst7 -r ${i}.rst7 -x ${i}.mdcrd -inf ${i}.mdinfo -p structure.parm7
done
